<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/MarkUp/Wilbur/HTML32.dtd"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:html="http://www.w3.org/MarkUp/Wilbur/HTML32.dtd"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwbehaviors="urn:WebWorks-Behaviors-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl html wwtoc wwlinks wwmode wwfiles wwdoc wwbehaviors wwsplits wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwunits wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterProjectSplitsType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterMergeType" />
 <xsl:param name="ParameterLocaleType" />
 <xsl:param name="ParameterUILocaleType" />
 <xsl:param name="ParameterTOCSplitFileType" />
 <xsl:param name="ParameterIndexSplitFileType" />
 <xsl:param name="ParameterCHMSplitFileType" />
 <xsl:param name="ParameterPageTemplateURI" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />
 <xsl:param name="ParameterMergeCategory" />
 <xsl:param name="ParameterMergeUse" />
 <xsl:param name="ParameterMergeDeploy" />


 <xsl:output encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="html" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:include href="wwtransform:common/pages/pagetemplate.xsl" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwproject-formatconfigurations-by-targetid" match="wwproject:FormatConfiguration" use="@TargetID" />
 <xsl:key name="wwsplits-files-by-groupid-type" match="wwsplits:File" use="concat(@groupID, ':', @type)" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath($ParameterPageTemplateURI), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath($ParameterPageTemplateURI)))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Locale -->
 <!--        -->
 <xsl:variable name="GlobalLocalePath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLocaleType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLocale" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLocalePath)" />


 <!-- UI Locale -->
 <!--           -->
 <xsl:variable name="GlobalUILocalePath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterUILocaleType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalUILocale" select="wwexsldoc:LoadXMLWithoutResolver($GlobalUILocalePath)" />


 <!-- Page Template -->
 <!--               -->
 <xsl:variable name="GlobalPageTemplatePath" select="wwuri:AsFilePath($ParameterPageTemplateURI)" />
 <xsl:variable name="GlobalPageTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalPageTemplatePath)" />


 <!-- Project Splits -->
 <!--                -->
 <xsl:variable name="GlobalProjectSplitsPath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterProjectSplitsType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalProjectSplits" select="wwexsldoc:LoadXMLWithoutResolver($GlobalProjectSplitsPath)" />


 <!-- Single Quote -->
 <!--              -->
 <xsl:variable name="GlobalSingleQuote">
  <xsl:text>&#39;</xsl:text>
 </xsl:variable>

 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Generate TOC? -->
   <!--               -->
   <xsl:if test="wwprojext:GetFormatSetting('toc-generate', 'true') = 'true'">
    <!-- Iterate input documents -->
    <!--                         -->
    <xsl:for-each select="$GlobalFiles[1]">
     <xsl:variable name="VarFilesByType" select="key('wwfiles-files-by-type', $ParameterDependsType)" />

     <xsl:variable name="VarProgressGroupsAndMergeStart" select="wwprogress:Start(count($VarFilesByType) + 1)" />

     <xsl:for-each select="$VarFilesByType">
      <xsl:variable name="VarProgressGroupTOCStart" select="wwprogress:Start(1)" />

      <xsl:variable name="VarFilesDocument" select="." />

      <!-- Load splits -->
      <!--             -->
      <xsl:variable name="VarFilesSplits" select="key('wwfiles-files-by-groupid-type', concat($VarFilesDocument/@groupID, ':', $ParameterSplitsType))[1]" />
      <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesSplits/@path)" />

      <xsl:for-each select="$VarSplits[1]">
       <!-- Split -->
       <!--       -->
       <xsl:variable name="VarSplit" select="key('wwsplits-files-by-groupid-type', concat($VarFilesDocument/@groupID, ':', $ParameterTOCSplitFileType))[1]" />

       <!-- Transform -->
       <!--           -->
       <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarSplit/@path, '', $VarFilesDocument/@groupID, $VarFilesDocument/@documentID, $GlobalActionChecksum)" />
       <xsl:if test="not($VarUpToDate)">
        <xsl:variable name="VarResultAsXML">
         <!-- Conditions -->
         <!--            -->
         <xsl:variable name="VarConditionsAsXML">
          <!-- No conditions defined -->
          <!--                       -->
         </xsl:variable>
         <xsl:variable name="VarConditions" select="msxsl:node-set($VarConditionsAsXML)" />

         <!-- Replacements -->
         <!--              -->
         <xsl:variable name="VarReplacementsAsXML">
          <!-- Content -->
          <!--         -->
          <wwpage:Replacement name="content">
           <!-- Load document -->
           <!--               -->
           <xsl:variable name="VarTOC" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesDocument/@path)" />

           <xsl:call-template name="TableOfContents">
            <xsl:with-param name="ParamSplits" select="$VarSplits" />
            <xsl:with-param name="ParamTOC" select="$VarTOC" />
            <xsl:with-param name="ParamSplit" select="$VarSplit" />
           </xsl:call-template>
          </wwpage:Replacement>
         </xsl:variable>
         <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)" />

         <!-- Output directory path -->
         <!--                       -->
         <xsl:variable name="VarOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwprojext:GetGroupName($VarSplit/@groupID))" />

         <!-- Invoke page template -->
         <!--                      -->
         <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate">
          <xsl:with-param name="ParamOutputDirectoryPath" select="$VarOutputDirectoryPath" />
          <xsl:with-param name="ParamOutputPath" select="$VarSplit/@path" />
          <xsl:with-param name="ParamConditions" select="$VarConditions" />
          <xsl:with-param name="ParamReplacements" select="$VarReplacements" />
         </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
        <xsl:variable name="VarEncoding" select="wwunits:EncodingFromCodePage($GlobalLocale/wwlocale:Locale/@codepage)" />
        <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarSplit/@path, $VarEncoding, 'html', '3.2', 'yes', 'yes', '', '-//IETF//DTD HTML//EN', '', '', 'text/html')" />
       </xsl:if>

       <!-- Report Files -->
       <!--              -->
       <wwfiles:File path="{$VarSplit/@path}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarSplit/@path)}" projectchecksum="" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
        <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
        <wwfiles:Depends path="{$GlobalUILocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalUILocalePath)}" groupID="" documentID="" />
        <wwfiles:Depends path="{$GlobalPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalPageTemplatePath)}" groupID="" documentID="" />
        <wwfiles:Depends path="{$VarFilesSplits/@path}" checksum="{$VarFilesSplits/@checksum}" groupID="{$VarFilesSplits/@groupID}" documentID="{$VarFilesSplits/@documentID}" />
        <wwfiles:Depends path="{$VarFilesDocument/@path}" checksum="{$VarFilesDocument/@checksum}" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" />
       </wwfiles:File>
      </xsl:for-each>

      <xsl:variable name="VarProgressGroupTOCEnd" select="wwprogress:End()" />
     </xsl:for-each>

     <!-- Merge -->
     <!--       -->
     <xsl:variable name="VarProgressMergeStart" select="wwprogress:Start(1)" />
     <xsl:if test="count($GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group) &gt; 1">
      <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />

      <xsl:variable name="VarMergePath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), concat(wwprojext:GetFormatName(), '.hhc'))" />

      <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarMergePath, concat($GlobalProject/wwproject:Project/@ChangeID, ':', count($VarProjectGroups)), '', '', $GlobalActionChecksum)" />
      <xsl:if test="not($VarUpToDate)">
       <xsl:variable name="VarResultAsXML">
        <!-- Conditions -->
        <!--            -->
        <xsl:variable name="VarConditionsAsXML">
         <!-- No conditions defined -->
         <!--                       -->
        </xsl:variable>
        <xsl:variable name="VarConditions" select="msxsl:node-set($VarConditionsAsXML)" />

        <!-- Replacements -->
        <!--              -->
        <xsl:variable name="VarReplacementsAsXML">
         <!-- Content -->
         <!--         -->
         <wwpage:Replacement name="content">
          <xsl:for-each select="$GlobalProject[1]">
           <!-- Merge settings -->
           <!--                -->
           <xsl:variable name="VarFormatConfiguration" select="key('wwproject-formatconfigurations-by-targetid', wwprojext:GetFormatID())[1]" />
           <xsl:variable name="VarMergeSettings" select="$VarFormatConfiguration/wwproject:MergeSettings" />

           <xsl:call-template name="MergeTableOfContents">
            <xsl:with-param name="ParamMergeSettings" select="$VarMergeSettings" />
            <xsl:with-param name="ParamPath" select="$VarMergePath" />
           </xsl:call-template>
          </xsl:for-each>
         </wwpage:Replacement>
        </xsl:variable>
        <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)" />

        <!-- Invoke page template -->
        <!--                      -->
        <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate">
         <xsl:with-param name="ParamOutputDirectoryPath" select="wwprojext:GetTargetOutputDirectoryPath()" />
         <xsl:with-param name="ParamOutputPath" select="$VarMergePath" />
         <xsl:with-param name="ParamConditions" select="$VarConditions" />
         <xsl:with-param name="ParamReplacements" select="$VarReplacements" />
        </xsl:apply-templates>
       </xsl:variable>
       <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
       <xsl:variable name="VarEncoding" select="wwunits:EncodingFromCodePage($GlobalLocale/wwlocale:Locale/@codepage)" />
       <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarMergePath, $VarEncoding, 'html', '3.2', 'yes', 'yes', '', '-//IETF//DTD HTML//EN', '', '', 'text/html')" />
      </xsl:if>

      <wwfiles:File path="{$VarMergePath}" type="{$ParameterMergeType}" checksum="{wwfilesystem:GetChecksum($VarMergePath)}" projectchecksum="{concat($GlobalProject/wwproject:Project/@ChangeID, ':', count($VarProjectGroups))}" groupID="" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterMergeCategory}" use="{$ParameterMergeUse}" deploy="{$ParameterMergeDeploy}">
       <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
       <wwfiles:Depends path="{$GlobalUILocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalUILocalePath)}" groupID="" documentID="" />
       <wwfiles:Depends path="{$GlobalPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalPageTemplatePath)}" groupID="" documentID="" />
       <wwfiles:Depends path="{$GlobalProjectSplitsPath}" checksum="{wwfilesystem:GetChecksum($GlobalProjectSplitsPath)}" groupID="" documentID="" />
      </wwfiles:File>
     </xsl:if>
     <xsl:variable name="VarProgressMergeEnd" select="wwprogress:End()" />

     <xsl:variable name="VarProgressGroupsAndMergeEnd" select="wwprogress:End()" />
    </xsl:for-each>
   </xsl:if>

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="NewLine">
  <xsl:text>
</xsl:text>
 </xsl:template>


 <xsl:template name="TableOfContents">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamTOC" />
  <xsl:param name="ParamSplit" />

  <xsl:call-template name="NewLine" />

  <xsl:variable name="VarIndent" select="'    '" />

  <!-- Handle empty TOCs -->
  <!--                   -->
  <xsl:choose>
   <xsl:when test="count($ParamTOC/wwtoc:TableOfContents/wwtoc:Entry[1]) &gt; 0">
    <xsl:call-template name="Entries">
     <xsl:with-param name="ParamSplits" select="$ParamSplits" />
     <xsl:with-param name="ParamParent" select="$ParamTOC/wwtoc:TableOfContents" />
     <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     <xsl:with-param name="ParamIndent" select="$VarIndent" />
    </xsl:call-template>
   </xsl:when>

   <xsl:otherwise>
    <!-- Without this workaround, the HTML Help compiler reports:                                                                                       -->
    <!--                                                                                                                                                -->
    <!-- HHC6000: Error: An internal file could not be created. Make certain there is enough disk space on the drive where you are compiling your file. -->
    <!-- HHC5007: Error: Fatal navigational compilation error. This is likely the result of an invalid contents .hhc file.                              -->
    <!--                                                                                                                                                -->

    <!-- Use first generated split -->
    <!--                           -->
    <xsl:variable name="VarFirstSplit" select="$ParamSplits/wwsplits:Splits/wwsplits:Split[1]" />

    <xsl:value-of select="$VarIndent" />
    <html:ul>
    <xsl:call-template name="NewLine" />
     <xsl:value-of select="$VarIndent" /><xsl:text>  </xsl:text>
     <wwexsldoc:LessThan />li<wwexsldoc:GreaterThan />
     <html:object type="text/sitemap">
     <xsl:call-template name="NewLine" />

      <xsl:value-of select="$VarIndent" /><xsl:text>        </xsl:text>
      <html:param name="Name" value="{$VarFirstSplit/@title}" />
      <xsl:call-template name="NewLine" />

      <xsl:variable name="VarGroupOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwprojext:GetGroupName($VarFirstSplit/@groupID), 'dummy.component')" />
      <xsl:variable name="VarPageRelativePath" select="wwfilesystem:GetRelativeTo($VarFirstSplit/@path, $VarGroupOutputDirectoryPath)" />

      <xsl:value-of select="$VarIndent" /><xsl:text>        </xsl:text>
      <html:param name="Local" value="{$VarPageRelativePath}" />
      <xsl:call-template name="NewLine" />

     <xsl:value-of select="$VarIndent" /><xsl:text>      </xsl:text>
     </html:object>
     <xsl:call-template name="NewLine" />
    <xsl:value-of select="$VarIndent" />
    </html:ul>
    <xsl:call-template name="NewLine" />

    <!-- Emit warning -->
    <!--              -->
    <xsl:variable name="VarMapTOCStylesMessage" select="$GlobalUILocale/wwlocale:Locale/wwlocale:Strings/wwlocale:String[@name = 'MapTOCStyles']/@value" />
    <xsl:variable name="VarWarningMapTOCStyles" select="wwlog:Warning($VarMapTOCStylesMessage)" />
   </xsl:otherwise>
  </xsl:choose>

  <xsl:text>  </xsl:text>
 </xsl:template>


 <xsl:template name="TOCText">
  <xsl:param name="ParamEntry" />

  <xsl:variable name="VarText">
   <xsl:call-template name="Paragraph">
    <xsl:with-param name="ParamParagraph" select="$ParamEntry/wwdoc:Paragraph" />
   </xsl:call-template>
  </xsl:variable>

  <xsl:variable name="VarFixSingleQuotes" select="wwstring:ReplaceWithExpression($VarText, '[&#8216;&#8217;]', $GlobalSingleQuote)" />
  <xsl:variable name="VarFixDoubleQuotes" select="wwstring:ReplaceWithExpression($VarFixSingleQuotes, '[&#8220;&#8221;]', '&quot;')" />

  <xsl:value-of select="$VarFixDoubleQuotes" />
 </xsl:template>


 <xsl:template name="Entries">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamParent" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamIndent" />

  <xsl:variable name="VarSubEntries" select="$ParamParent/wwtoc:Entry" />

  <xsl:for-each select="$VarSubEntries[1]">
   <xsl:value-of select="$ParamIndent" />
   <html:ul>
   <xsl:call-template name="NewLine" />
    <xsl:for-each select="$VarSubEntries">
     <xsl:variable name="VarEntry" select="." />

     <xsl:value-of select="$ParamIndent" /><xsl:text>  </xsl:text>
     <wwexsldoc:LessThan />li<wwexsldoc:GreaterThan />
     <html:object type="text/sitemap">
     <xsl:call-template name="NewLine" />
      <xsl:choose>
       <xsl:when test="string-length($VarEntry/@path) &gt; 0">
        <!-- Get link -->
        <!--          -->
        <xsl:variable name="VarRelativeLinkPath" select="wwfilesystem:GetRelativeTo($VarEntry/@path, $ParamSplit/@path)" />

        <xsl:variable name="VarLink">
         <xsl:value-of select="$VarRelativeLinkPath" />

         <xsl:if test="$VarEntry/@first = 'false'">
          <xsl:text>#</xsl:text>
          <xsl:value-of select="$VarEntry/@linkid" />
         </xsl:if>
        </xsl:variable>
        <xsl:variable name="VarTOCText">
         <xsl:call-template name="TOCText">
          <xsl:with-param name="ParamEntry" select="$VarEntry" />
         </xsl:call-template>
        </xsl:variable>

        <xsl:value-of select="$ParamIndent" /><xsl:text>        </xsl:text>
        <html:param name="Name" value="{wwstring:ReplaceWithExpression($VarTOCText, '[&#8216;&#8217;&#8220;&#8221;]', '&quot;')}" />
        <xsl:call-template name="NewLine" />

        <xsl:value-of select="$ParamIndent" /><xsl:text>        </xsl:text>
        <html:param name="Local" value="{$VarLink}" />
        <xsl:call-template name="NewLine" />

        <!-- Window type -->
        <!--             -->
        <xsl:variable name="VarLinkSplit" select="$ParamSplits/wwsplits:Splits/wwsplits:Split[@path = $VarEntry/@path]" />
        <xsl:if test="string-length($VarLinkSplit/@window-type) &gt; 0">
         <xsl:value-of select="$ParamIndent" /><xsl:text>        </xsl:text>
         <html:param name="WindowName" value="{$VarLinkSplit/@window-type}" />
         <xsl:call-template name="NewLine" />
        </xsl:if>
       </xsl:when>

       <xsl:otherwise>
        <xsl:variable name="VarTOCTextNoLink">
         <xsl:call-template name="TOCText">
          <xsl:with-param name="ParamEntry" select="$VarEntry" />
         </xsl:call-template>
        </xsl:variable>

        <xsl:value-of select="$ParamIndent" /><xsl:text>        </xsl:text>
        <html:param name="Name" value="{wwstring:ReplaceWithExpression($VarTOCTextNoLink, '[&#8216;&#8217;&#8220;&#8221;]', '&quot;')}" />
        <xsl:call-template name="NewLine" />
       </xsl:otherwise>
      </xsl:choose>

      <!-- TOC Icon -->
      <!--          -->
      <xsl:variable name="VarTOCIconMarkers" select="$VarEntry/wwbehaviors:Paragraph/wwbehaviors:Marker[@behavior = 'toc-icon-html-help']" />

      <xsl:if test="count($VarTOCIconMarkers) &gt; 0">
       <xsl:variable name="VarTOCIconMarker" select="$VarTOCIconMarkers[count($VarTOCIconMarkers)]" />
       <xsl:variable name="VarTOCIconText">
        <xsl:for-each select="$VarTOCIconMarker//wwdoc:TextRun/wwdoc:Text">
         <xsl:value-of select="@value" />
        </xsl:for-each>
       </xsl:variable>

       <!-- Validate value -->
       <!--                -->
       <xsl:variable name="VarTOCIconAsNumber" select="number($VarTOCIconText)" />
       <xsl:choose>
        <xsl:when test="($VarTOCIconAsNumber &gt; 0) and ($VarTOCIconAsNumber &lt; 43)">
         <xsl:value-of select="$ParamIndent" /><xsl:text>        </xsl:text>
         <html:param name="ImageNumber" value="{$VarTOCIconText}" />
         <xsl:call-template name="NewLine" />
        </xsl:when>

        <xsl:otherwise>
         <xsl:variable name="VarWarningInvalidTOCIcon" select="wwlog:Warning(concat('Invalid TOCIcon value: ', $VarTOCIconText, ': Ignoring marker.'))" />
        </xsl:otherwise>
       </xsl:choose>
      </xsl:if>
     <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
     </html:object>
     <xsl:call-template name="NewLine" />

     <xsl:variable name="VarIndent">
      <xsl:value-of select="$ParamIndent" />
      <xsl:text>  </xsl:text>
     </xsl:variable>

     <xsl:call-template name="Entries">
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamParent" select="$VarEntry" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
      <xsl:with-param name="ParamIndent" select="$VarIndent" />
     </xsl:call-template>
    </xsl:for-each>
   <xsl:value-of select="$ParamIndent" />
   </html:ul>
   <xsl:call-template name="NewLine" />
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Paragraph">
  <xsl:param name="ParamParagraph" />

  <xsl:variable name="VarText">
   <xsl:for-each select="$ParamParagraph/wwdoc:Number/wwdoc:Text | $ParamParagraph/wwdoc:TextRun/wwdoc:Text">
    <xsl:value-of select="@value" />
   </xsl:for-each>
  </xsl:variable>
  <xsl:value-of select="normalize-space($VarText)" />
 </xsl:template>


 <xsl:template name="MergeTableOfContents">
  <xsl:param name="ParamMergeSettings" />
  <xsl:param name="ParamPath" />

  <xsl:call-template name="NewLine" />

  <xsl:value-of select="'    '" />
  <html:ul>
  <xsl:call-template name="NewLine" />

   <xsl:apply-templates select="$ParamMergeSettings/wwproject:*" mode="wwmode:merge">
    <xsl:with-param name="ParamPath" select="$ParamPath" />
    <xsl:with-param name="ParamIndent" select="'      '" />
   </xsl:apply-templates>

  <xsl:value-of select="'    '" />
  </html:ul>
  <xsl:call-template name="NewLine" />

  <xsl:text>  </xsl:text>
 </xsl:template>


 <xsl:template match="wwproject:TOC" mode="wwmode:merge">
  <xsl:param name="ParamPath" />
  <xsl:param name="ParamIndent" />
  <xsl:param name="ParamTOC" select="." />

  <xsl:value-of select="$ParamIndent" />
  <wwexsldoc:LessThan />li<wwexsldoc:GreaterThan />
  <html:object type="text/sitemap">
  <xsl:call-template name="NewLine" />

   <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
   <html:param name="Name" value="{$ParamTOC/@Name}" />
   <xsl:call-template name="NewLine" />

  <xsl:value-of select="$ParamIndent" /><xsl:text>    </xsl:text>
  </html:object>
  <xsl:call-template name="NewLine" />

  <xsl:value-of select="$ParamIndent" />
  <html:ul>
   <xsl:variable name="VarIndent">
    <xsl:value-of select="$ParamIndent" />
    <xsl:text>  </xsl:text>
   </xsl:variable>

   <xsl:call-template name="NewLine" />
    <xsl:apply-templates mode="wwmode:merge">
     <xsl:with-param name="ParamPath" select="$ParamPath" />
     <xsl:with-param name="ParamIndent" select="$VarIndent" />
    </xsl:apply-templates>

  <xsl:value-of select="$ParamIndent" />
  </html:ul>
  <xsl:call-template name="NewLine" />
 </xsl:template>


 <xsl:template match="wwproject:MergeGroup" mode="wwmode:merge">
  <xsl:param name="ParamPath" />
  <xsl:param name="ParamIndent" />
  <xsl:param name="ParamMergeGroup" select="." />

  <xsl:for-each select="$GlobalProject[1]">
   <xsl:variable name="VarGroupName" select="wwprojext:GetGroupName($ParamMergeGroup/@GroupID)" />

   <xsl:variable name="VarTitle">
    <xsl:choose>
     <xsl:when test="string-length($ParamMergeGroup/@Title) &gt; 0">
      <xsl:value-of select="$ParamMergeGroup/@Title" />
     </xsl:when>

     <xsl:otherwise>
      <xsl:value-of select="$VarGroupName" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <xsl:for-each select="$GlobalProjectSplits[1]">
    <xsl:variable name="VarCHMSplit" select="key('wwsplits-files-by-groupid-type', concat($ParamMergeGroup/@GroupID, ':', $ParameterCHMSplitFileType))[1]" />
    <xsl:variable name="VarTOCSplit" select="key('wwsplits-files-by-groupid-type', concat($ParamMergeGroup/@GroupID, ':', $ParameterTOCSplitFileType))[1]" />
    <xsl:variable name="VarCHMRelativePath" select="wwfilesystem:GetFileName($VarCHMSplit/@path)" />
    <xsl:variable name="VarGroupOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), $VarGroupName, 'dummy.component')" />
    <xsl:variable name="VarTOCRelativePath" select="wwfilesystem:GetRelativeTo($VarTOCSplit/@path, $VarGroupOutputDirectoryPath)" />

    <xsl:variable name="VarTOCReference" select="concat($VarCHMRelativePath, '::/', $VarTOCRelativePath)" />

    <xsl:value-of select="$ParamIndent" />
    <wwexsldoc:LessThan />li<wwexsldoc:GreaterThan />
    <html:object type="text/sitemap">
    <xsl:call-template name="NewLine" />

     <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
     <html:param name="Name" value="{$VarTitle}" />
     <xsl:call-template name="NewLine" />

    <xsl:value-of select="$ParamIndent" /><xsl:text>    </xsl:text>
    </html:object>
    <xsl:call-template name="NewLine" />

    <xsl:value-of select="$ParamIndent" /><xsl:text>    </xsl:text>
    <html:object type="text/sitemap">
    <xsl:call-template name="NewLine" />

     <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
     <html:param name="Merge" value="{$VarTOCReference}" />
     <xsl:call-template name="NewLine" />

    <xsl:value-of select="$ParamIndent" /><xsl:text>    </xsl:text>
    </html:object>
    <xsl:call-template name="NewLine" />
   </xsl:for-each>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
